/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.util;

import org.w3c.rdf.model.*;
import org.w3c.rdf.syntax.*;

/**
 * A factory used to create RDF parser/serializer, empty flat models,
 * schema-aware models out of flat models and schema registry.
 * This interface is provided to enable applications to use their
 * own implementations of the above mentioned components in a uniform way.
 *
 * @author Sergey Melnik <melnik@db.stanford.edu>
 */

public interface RDFFactory {

  /**
   * Creates a new RDF parser
   */
  public RDFParser createParser();

  /**
   * Creates a new RDF serializer
   */
  public RDFSerializer createSerializer();

  /**
   * Create an empty flat model.
   */
  public Model createModel();

}
