/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.implementation.model;

import org.w3c.rdf.model.Resource;

public class ResourceImpl extends RDFNodeImpl implements Resource {

  protected ResourceImpl() {
  }

  public ResourceImpl (String uri) {
    super(uri);
  }

  public String getURI() {
    return label;
  }

  public boolean equals (Object that) {

    if (this == that) {
      return true;
    }
    if (that == null || !(that instanceof Resource)) {
      return false;
    }

    return super.equals(that);
  }
}
