/**
 * Copyright  Sergey Melnik (Stanford University, Database Group) 
 *
 * Distribution policies are governed by the W3C software license.
 * http://www.w3.org/Consortium/Legal/copyright-software   
 * 
 * All Rights Reserved.
 * 
 * @author      Sergey Melnik <melnik@db.stanford.edu>
 */

package org.w3c.rdf.examples;

import org.xml.sax.SAXException;
import org.w3c.rdf.model.*;
import org.w3c.rdf.util.*;

/**
 * A simple demo program that parses RDF at a given URL,
 * serializes it back into RDF/XML, and dumps the triples.
 *
 * <p>Try <code>java org.w3c.rdf.examples.ParseAndSerialize http://www-db.stanford.edu/~melnik/</code>
 */

public class ParseAndSerialize {

  public static void main(String[] args) throws Exception {

    if(args.length == 0) {
      System.err.println("ParseAndSerialize <fileNameOrURL>");
      System.exit(1);
    }

    String fileNameOrURL = args[0];
    RDFFactory f = new RDFFactoryImpl();
    Model m = f.createModel();

		try {
			RDFUtil.parse(fileNameOrURL, f.createParser(), m);
		} catch (SAXException se) {
			System.err.println("Exception during parsing:");
			throw se.getException();
		}

    System.err.println("\nTRIPLES:\n");
    RDFUtil.printStatements(m, System.out);

    System.err.println("\nSERIALIZED MODEL:\n");
    RDFUtil.dumpModel(m, System.out, f.createSerializer());

    System.err.println("\nModel " + m.getURI() + " of size " + m.size() + "\n");
  }
}
