#!/bin/python
"""
# # # # # # # # # # # # # # # # # # # # # # # #
#                                             #
#   CWM.py Utility Program - Sean B. Palmer   #
#   - http://infomesh.net/2001/05/cwmutil/    #
#                                             #
# # # # # # # # # # # # # # # # # # # # # # # #
"""

import sys, os, string, re, StringIO

python = 'python'
cwmdir = '/home/cwm/'
rules = '/home/cwm/rules.n3'

sys.argv.append(''); sys.argv.append('')
cwm, s1, s2 = cwmdir+'cwm.py', sys.argv[1], sys.argv[2]

prompt = """
    c) Clean up the file
    t) Think and output
    r) Think using srules/drules and output
    x) Convert to XML RDF
    m) Merge 2 files
    s) Spart
    f) Flatten
    n) XML RDF to N3
    p) Think and purge

Choose a letter: """

def spart(): 
   sys.stderr.write('Processing...\n')
   stdout = os.popen('python '+cwm+' file:'+s1+' --ntriples --bySubject', 'r')
   s = stdout.read()
   results = re.compile(r'(\"\"\".*?\"\"\")', re.S).findall(s)
   for m in results: 
      mnew = string.replace(m[3:-3], '"', '\\"')
      mnew = '"'+string.replace(mnew, '\n', '')+'"'
      s = string.replace(s, m, mnew)
   print s

def doCommand(command): 
   sys.stderr.write('Processing...\n')
   stdout = os.popen(command, 'r')
   print stdout.read()

def run(): 
   sys.stderr.write(prompt)
   g = raw_input()
   if g == 'c': doCommand('python '+cwm+' file:'+s1)
   elif g == 't': doCommand('python '+cwm+' file:'+s1+' --think')
   elif g == 'r': doCommand('python '+cwm+' file:'+s1+' --think --apply='+rules)
   elif g == 'x': doCommand('python '+cwm+' file:'+s1+' --rdf')
   elif g == 'm': doCommand('python '+cwm+' file:'+s1+' file:'+s2)
   elif g == 'f': doCommand('python '+cwm+' file:'+s1+' --flat')
   elif g == 'n': doCommand('python '+cwm+' --rdf file:'+s1+' --n3')
   elif g == 'p': doCommand('python '+cwm+' file:'+s1+' --think --purge')
   elif g == 's': spart()
   else: sys.stderr.write('Unknown command')

if __name__=="__main__": 
   sys.stderr.write(string.lstrip(__doc__))
   run()